"""
HB_Group V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Group
Description-US: Group each selected Object under a Null

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=38m12s

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d

def main():
    doc.StartUndo()
    sel=doc.GetSelection()
    for obj in sel:
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)        
        objPos=obj.GetMg()
        null=c4d.BaseObject(c4d.Onull)
        name=obj.GetName()+str("_Root")
        doc.AddUndo(c4d.UNDOTYPE_NEW, null)
        null.SetName(name)
        doc.InsertObject(null, None, obj)
        null.SetMg(objPos)
        doc.SetSelection(null, c4d.SELECTION_ADD)
        doc.SetSelection(obj, c4d.SELECTION_SUB)
        obj.InsertUnder(null)
        obj.SetMg(objPos)
        
    doc.EndUndo()
    c4d.EventAdd()

if __name__=='__main__':
    main()
